%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
% parameters to play around with 

n = 500; %%% network size
N = round(sqrt(n));  %%% small community size (keep N << n, roughly)
c = 0.1; %%% large community edge probability


%%%%%%%%%%%%%%%%%%%%% 
a_max = min(1,(n-N-1)*c/(N-1));
a_vec = colon(c,0.02,a_max); %linspace(c, a_max, 50);
M = 50; %%% number of repetitions 
alpha = 0.05; %%% level of test 

%%%%%%%%%%%%%%%%%%%%%

%%% membership matrix Pi
Pi  = [ones(N, 1)', zeros(n- N,1)'; zeros(N, 1)', ones(n- N,1)']';

%%% structure matrices P_null, Omega_null
P_null = c*ones(2,1)*ones(2,1)';

Omega_null = Pi*P_null*Pi';


%%%%%%%%%%%%%%%%%%%%%%%%%%%%% draw power curve for chi2

power_vec = zeros(length(a_vec),1);

for a_vec_idx = 1:length(a_vec)
    pvalue_vec = zeros(M, 1);
    a = a_vec(a_vec_idx); 

    %%% construct structure matrix P_alt 
    b = c;     %%%no degree matching
    P_alt = [a, b; b, c];       %%% structure matrix
    Omega_alt = Pi*P_alt*Pi';
    
    for rep_idx = 1:M

        %%%generate Omega under alternative 
        A_alt = binornd(ones(n,n), Omega_alt );
        A_alt = A_alt - tril(A_alt) ;
        A_alt = A_alt + A_alt';

        %%% compute pvalue with chi2
        pvalue_vec(rep_idx) = chi2(A_alt); 
    end 
    
    rejections = sum(pvalue_vec < alpha);
    power_vec(a_vec_idx) = rejections/M;

end 
figure 
plot( a_vec , power_vec, 'black' )

hold on 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%% draw power curve for SgnQ

power_vec2 = zeros(length(a_vec),1);

for a_vec_idx = 1:length(a_vec)
    pvalue_vec = zeros(M, 1);
    a = a_vec(a_vec_idx); 

    %%% construct structure matrix P_alt 
    b = c;     %%%no degree matching
    P_alt = [a, b; b, c];       %%% structure matrix
    Omega_alt = Pi*P_alt*Pi';
    
    for rep_idx = 1:M

        %%%generate Omega under alternative 
        A_alt = binornd(ones(n,n), Omega_alt );
        A_alt = A_alt - tril(A_alt) ;
        A_alt = A_alt + A_alt';

        %%% compute pvalue with chi2
        pvalue_vec(rep_idx) = SgnQ(A_alt); 
    end 
    
    rejections = sum(pvalue_vec < alpha);
    power_vec2(a_vec_idx) = rejections/M;

end 

plot( a_vec , power_vec2, 'blue' )

legend( 'chi2 power', 'SgnQ power')






